/*
 * Copyright (c) 2001-2003, Raphael Manfredi, Richard Eckart
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

#ifndef _gtk_nodes_h_
#define _gtk_nodes_h_

#include "gui.h"
#include "if/core/nodes.h"

void nodes_gui_early_init(void);
void nodes_gui_init(void);
void nodes_gui_shutdown(void);

void nodes_gui_add_node(gnet_node_info_t *n);
void nodes_gui_remove_node(const struct nid *node_id);
void nodes_gui_update_node(gnet_node_info_t *, gboolean);
void nodes_gui_update_nodes_display(time_t now);

void nodes_gui_remove_selected(void);

#endif /* _gtk_nodes_h_ */
