# - Find GLIB
# Find the GLIB includes and libraries.
# This module defines:
#  GLIB_FOUND
#  GLIB_INCLUDE_DIRS
#  GLIB_LIBRARIES

find_package(PkgConfig QUIET)
pkg_check_modules(GLIB QUIET glib-2.0)

find_path(GLIB_INCLUDE_DIR
  NAMES glib.h
  PATHS ${GLIB_INCLUDE_DIRS}
  PATH_SUFFIXES glib-2.0
)

if((NOT GLIB_INCLUDE_DIRS) AND (GLIB_INCLUDE_DIR))
  set(GLIB_INCLUDE_DIRS ${GLIB_INCLUDE_DIR})
elseif(GLIB_INCLUDE_DIRS AND GLIB_INCLUDE_DIR)
  list(APPEND GLIB_INCLUDE_DIRS ${GLIB_INCLUDE_DIR})
endif()

find_library(GLIB_LIBRARY
  NAMES ${GLIB_LIBRARIES} glib-2.0
)

if((NOT GLIB_LIBRARIES) AND (GLIB_LIBRARY))
  set(GLIB_LIBRARIES ${GLIB_LIBRARY})
elseif(GLIB_LIBRARIES AND GLIB_LIBRARY)
  list(APPEND GLIB_LIBRARIES ${GLIB_LIBRARY})
endif()

message(VERBOSE "GLIB_INCLUDE_DIRS=${GLIB_INCLUDE_DIRS}")
message(VERBOSE "GLIB_INCLUDE_DIR=${GLIB_INCLUDE_DIR}")
message(VERBOSE "GLIB_LIBRARIES=${GLIB_LIBRARIES}")
message(VERBOSE "GLIB_LIBRARY=${GLIB_LIBRARY}")

if((NOT GLIB_FOUND) AND (GLIB_INCLUDE_DIRS) AND (GLIB_LIBRARIES))
  set(GLIB_FOUND True)
endif()

include(FindPackageHandleStandardArgs)

if(GLIB_FOUND)
  find_package_handle_standard_args(GLIB
    REQUIRED_VARS GLIB_FOUND GLIB_INCLUDE_DIRS GLIB_LIBRARIES
    VERSION_VAR GLIB_VERSION
  )
else()
  find_package_handle_standard_args(GLIB
    REQUIRED_VARS GLIB_FOUND
  )
endif()

mark_as_advanced(GLIB_INCLUDE_DIR GLIB_LIBRARY)
