/*
// $Id: //open/dev/farrago/src/org/eigenbase/oj/stmt/PreparedResult.java#12 $
// Package org.eigenbase is a class library of data management components.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2002-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package org.eigenbase.oj.stmt;

import org.eigenbase.rel.*;


/**
 * PreparedResult represents the result of a call to OJPreparingStmt.prepareSql.
 *
 * @author John V. Sichi
 * @version $Id: //open/dev/farrago/src/org/eigenbase/oj/stmt/PreparedResult.java#12 $
 */
public interface PreparedResult
{
    //~ Methods ----------------------------------------------------------------

    /**
     * @return the code generated by preparation
     */
    String getCode();

    /**
     * @return true iff this result is for a DML statement, in which case the
     * result set is one row with one column containing the number of rows
     * affected.
     */
    boolean isDml();

    /**
     * @return the table modification operation corresponding to this statement
     * if it is a table modification statement; otherwise null
     */
    TableModificationRel.Operation getTableModOp();

    /**
     * Executes the prepared result.
     *
     * @return producer of rows resulting from execution
     */
    Object execute();
}

// End PreparedResult.java
